<id>
YaBB Board Index Folding Mod
</id>

<version>
1.2
</version>

<mod info>
This mod allows registered members to fold the categories in the board index they are not interested in, making the board
faster and more clear, especially for large boards with a lot of categories.
Actually this is an optical rework of the Collapsable YaBB Front End mod by snYpir from boardmod.
It's made compatible for SP1.1 and independent from Notify plus 2.2

Version History.
1.2
Added indication of new posts in folded categories

1.1
Rework and styling redone for SP1.1

1.0
Initial release by snYpir (morpj97@hn.ozemail.com.au). (on boardmod)

How to install this mod

As usual after making a backup you can install this mod using boardmod 2.5
This mod changes the following files :
YaBB.pl
dutch.lng
Sources/boardindex.pl

Upload the three image gifs into your YaBBImages dir
Upload the modified files to your webserver.

NOTE !
The first time a registered user logs in all categories will be folded in and after he/she selected the categories of 
interest this will be saved for future use in a separate file per user called <username>.cat

</mod info>

<author>
Ron A.J. Hartendorp
</author>

<homepage>
www.spikecity.net
</homepage>

<edit file>
Sources\BoardIndex.pl
</edit file>

<search for>
        <td class="titlebg" bgcolor="$color{'titlebg'}" colspan="2"><font class="text1" color="$color{'titletext'}" size="2"><b>$txt{'20'}</b></font></td>
</search for>

<replace>
~;
########### Board Folding Mod ##########
    # expand/collapse all buttons
    if ( $username ne 'Guest' ){
       $yymain .= qq~
       <td class="titlebg" bgcolor="$color{'titlebg'}" colspan="2">
          <table>
          <tr>
               <td>
                  <a href=$cgi&action=collapse_all&status=1><img src="$imagesdir/fold_up.gif" alt="$foldtxt{'6'}" border="0"></a></td>
               </td>
               <td>
                 <font class="text1" color="$color{'titletext'}" size="2"><b>$txt{'20'}</b></font></td>
                </td>
               <td>
                  <a href=$cgi&action=collapse_all&status=0><img src="$imagesdir/fold_out.gif" alt="$foldtxt{'5'}" border="0"></a></td>
               </td>
          </tr>
          </table>
       </td>~;
    }
    else{
       $yymain .= qq~<td class="titlebg" bgcolor="$color{'titlebg'}" colspan="2"><font class="text1" color="$color{'titletext'}" size="2"><b>$txt{'20'}</b></font></td>~;
    }
########### Board Folding Mod ##########
$yymain .= qq~
</replace>

<search for>
	foreach $curcat (@categories) {
		unless( $openmemgr{$curcat} ) { next; }
</search for>

<add before>

########### Board Folding Mod ##########
   # init catstatus counter
   $catcount=0;
   if ( $username ne 'Guest' ){
      # load the .cat file for this user, put into array
      fopen(FILE, "$memberdir/$username.cat");
      @catstatus = <FILE>;
      fclose(FILE);

      # remove trailing newline chars
      for( $catnum = 0; $catnum < @catstatus; $catnum++ ) {
         chomp $catstatus[$catnum];
      }

      # .cat file for this user not found, or number of categories changed?
      if ( @catstatus ne @categories ){
         # write new .cat file for user
         fopen( FILE, ">$memberdir/$username.cat", 1);
         for( $catnum = 0; $catnum < @categories; $catnum++ ) {
            print FILE "1\n";
         }
         fclose(FILE);
      }
   }
########### Board Folding Mod ##########

</add before>

<search for>
        <td colspan="5" class="catbg" bgcolor="$color{'catbg'}" height="18"><a name="$curcat"> <font size=2>$caticon <b>$catname{$curcat}</b></font></a></td>
</search for>

<replace>

      ~;
########### Board Folding Mod ##########
	if ( $username ne 'Guest' ) {
		$newcount = 0;
		if( $catstatus[$catcount]){
			$foldpic = "fold_out.gif";
			$foldtxt = $foldtxt{'2'};
		}else{
			foreach $curboard (@{$catboards{$curcat}}) {
				chomp $curboard;
				$dlp = &getlog($curboard);
				if( $max_log_days_old && $lastposttime{$curboard} ne $txt{'470'} && $username ne 'Guest' && $dlp < stringtotime( $lastpostrealtime{$curboard} ) ) {
					$newcount++;
				}
			}
			if($newcount>0){
				$foldpic = "fold_up_new_mail.gif";
				$foldtxt = $foldtxt{'1'};
			}
			if($newcount==0){
				$foldpic = "fold_up.gif";
				$foldtxt = $foldtxt{'1'};
			}
		}
         $yymain .= qq~
         <td colspan="5" class="catbg" bgcolor="$color{'catbg'}" height="18"><a name="$curcat"><a href=$cgi&action=collapse_cat&cat=$catcount><img src="$imagesdir/$foldpic" alt="$foldtxt" border="0"> <b>$catname{$curcat}</a></td>~;
      }
      else{
         $yymain .= qq~
         <td colspan="5" class="catbg" bgcolor="$color{'catbg'}" height="18"><a name="$curcat"><font size=2><b>$catname{$curcat}</b></font></td>~;
      }
########### Board Folding Mod ##########
      $yymain .= qq~

</replace>

<search for>
		foreach $curboard (@{$catboards{$curcat}}) {
			chomp $curboard;
</search for>

<add before>

########### Board Folding Mod ##########
   # if category is open, display boards (or if this user is a guest)
   if( $catstatus[$catcount] || $username eq 'Guest' ){
########### Board Folding Mod ##########

</add before>

<search for>
	}
	my $checkadded = 0;
</search for>

<add before>

########### Board Folding Mod ##########
     #endif
     }
     ++$catcount;
########### Board Folding Mod ##########

</add before>

<search for>
sub MarkAllRead {
</search for>

<add before>

########### Board Folding Mod ##########
sub Collapse_Cat {
   if ( $username eq 'Guest' ){
      &fatal_error($foldtxt{'4'});
      exit;            
   }
      
   # Grab the index of the category to collapse/expand
   $catindex = $INFO{'cat'};

   # read the current users category file
   fopen(FILE, "$memberdir/$username.cat");
   @catstatus = <FILE>;
   fclose(FILE);
  
   # remove trailing newline chars
   for( $catnum = 0; $catnum < @catstatus; $catnum++ ) {
      chomp $catstatus[$catnum];
      # fix in case using older version
      	if ( $catstatus[$catnum] eq "true" ){ $catstatus[$catnum] = 1; }
      	if ( $catstatus[$catnum] eq "false" ){ $catstatus[$catnum] = 0; } 
   }      
  
   # does the file exist?
   if ( $catstatus[0] != 1 && $catstatus[0] != 0 ){
      &fatal_error($foldtxt{'3'});
      exit;
   }
      
   # toggle the status of the selected category
   if ( $catstatus[$catindex] eq 1 ){
      $catstatus[$catindex] = 0;
   }
   else{
      $catstatus[$catindex] = 1;
   }

   # rewrite category file for this user
   fopen( FILE, ">$memberdir/$username.cat", 1);
   for( $catnum = 0; $catnum < @catstatus; $catnum++ ) {      
      print FILE "$catstatus[$catnum]\n";   
   }
   fclose(FILE);

   &redirectinternal;
   exit;   
}

sub Collapse_All {
   $state = '0';
   
   $state = $INFO{'status'};
   
   if ( $username eq 'Guest' ){
      &fatal_error($foldtxt{'4'});
      exit;            
   }   
   
   # read the current users category file
   fopen(FILE, "$memberdir/$username.cat");
   @catstatus = <FILE>;
   fclose(FILE);
  
   # remove trailing newline chars
   for( $catnum = 0; $catnum < @catstatus; $catnum++ ) {
      chomp $catstatus[$catnum];
      # fix in case using older version
      if ( $catstatus[$catnum] eq "true" ){ $catstatus[$catnum] = 1; }
      if ( $catstatus[$catnum] eq "false" ){ $catstatus[$catnum] = 0; }      
   }     
  
   # does the file exist?
   if ( $catstatus[0] != 1 && $catstatus[0] != 0 ){
      &fatal_error($foldtxt{'3'});
      exit;
   }   
   
   # rewrite category file for this user
   fopen( FILE, ">$memberdir/$username.cat", 1);
   for( $catnum = 0; $catnum < @catstatus; $catnum++ ) {      
      print FILE "$state\n";   
   }
   fclose(FILE);   

   &redirectinternal;
   exit;  
}
########### Board Folding Mod ##########

</add before>

<edit file>
english.lng
</edit file>

<search for>
$yycopyright = qq~<a href="$boardurl/YaBB.$yyext"><font size="1">$mbname</font></a> &#187; <font size="1">Powered by</font> <a href="http://www.yabbforum.com"><font size="1">YaBB $YaBBversion</font></a><font size="1">!<BR>\nYaBB  2000-2002, </font><a href="http://www.xnull.com"><font size="1">Xnull</font></a><font size="1">. All Rights Reserved.</font>~;
</search for>

<add before>

########### Board Folding Mod ##########
	$foldtxt{'1'} = "Unfold this Category";
	$foldtxt{'2'} = "Fold this Category";
	$foldtxt{'3'} = "Category File not found ! - Click on Refresh to reload the index.\n If this error is persistant please notify the administrator.";
	$foldtxt{'4'} = "Only registered member can Fold Categories!";
	$foldtxt{'5'} = "Fold the complete Board Index";
	$foldtxt{'6'} = "Unfold the complete Board index";
########### Board Folding Mod ##########

</add before>

<edit file>
YaBB.pl
</edit file>

<search for>
	elsif ($action eq 'clean_log') { require "$sourcedir/Admin.pl"; &clean_log; }
</search for>

<add after>
	elsif ($action eq 'collapse_cat') { require "$sourcedir/BoardIndex.pl"; &Collapse_Cat; }
	elsif ($action eq 'collapse_all') { require "$sourcedir/BoardIndex.pl"; &Collapse_All; }
</add after>
